/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers.vfx;

import cofh.core.client.CoreRenderType;
import cofh.core.init.CoreShaders;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class RenderTypes {
    public static final ResourceLocation BLANK_TEXTURE = new ResourceLocation("cofh_core", "textures/render/blank.png");
    public static final ResourceLocation LIN_GLOW_TEXTURE = new ResourceLocation("cofh_core", "textures/render/glow_linear.png");
    public static final ResourceLocation RND_GLOW_TEXTURE = new ResourceLocation("cofh_core", "textures/render/glow_round.png");
    private static final RenderStateShard.DepthTestStateShard DISABLE_DEPTH = new RenderStateShard.DepthTestStateShard("none", 519){

        public void m_110185_() {
            RenderSystem.disableDepthTest();
        }
    };
    public static final RenderType OVERLAY_LINES = RenderType.m_173215_((String)"cofh:overlay_lines", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110673_(CoreRenderType.THICK_LINES).m_173292_(RenderStateShard.f_173095_).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110687_(RenderStateShard.f_110115_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
    public static final RenderType OVERLAY_BOX = RenderType.m_173215_((String)"cofh:overlay_box", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_110685_(RenderStateShard.f_110139_).m_110687_(RenderStateShard.f_110115_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
    public static final RenderType FLAT_CUTOUT = RenderTypes.opaque("cofh_core:opaque", new RenderStateShard.TextureStateShard(BLANK_TEXTURE, false, false));
    public static final RenderType FLAT_TRANSLUCENT = RenderTypes.translucentNoDepthWrite(BLANK_TEXTURE);
    public static final RenderType LINEAR_GLOW = RenderTypes.translucentNoDepthWrite(LIN_GLOW_TEXTURE);
    public static final RenderType ROUND_GLOW = RenderTypes.translucentNoDepthWrite(RND_GLOW_TEXTURE);
    public static ParticleRenderType PARTICLE_SHEET_OVER = RenderTypes.translucentSheet(() -> CoreShaders.PARTICLE_OVER);
    public static ParticleRenderType PARTICLE_SHEET_ADDITIVE_MULTIPLY = RenderTypes.translucentSheet(() -> CoreShaders.PARTICLE_ADDITIVE_MULTIPLY);
    public static ParticleRenderType PARTICLE_SHEET_ADDITIVE_SCREEN = RenderTypes.translucentSheet(() -> CoreShaders.PARTICLE_ADDITIVE_SCREEN);

    public static RenderType opaque(String name, RenderStateShard.TextureStateShard texture) {
        return RenderType.m_173215_((String)name, (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)texture).m_173292_(RenderStateShard.f_173112_).m_110691_(false));
    }

    public static RenderType translucent(ResourceLocation texture) {
        return RenderType.m_173215_((String)"cofh_core:translucent", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(RenderStateShard.f_173110_).m_110675_(RenderStateShard.f_110123_).m_110687_(RenderStateShard.f_110114_).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110691_(false));
    }

    public static RenderType translucentNoCull(ResourceLocation texture) {
        return RenderType.m_173215_((String)"cofh_core:translucent", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(RenderStateShard.f_173110_).m_110675_(RenderStateShard.f_110123_).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110685_(RenderStateShard.f_110139_).m_110691_(false));
    }

    public static RenderType translucentNoDepthWrite(ResourceLocation texture) {
        return RenderType.m_173215_((String)"cofh_core:translucent", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(RenderStateShard.f_173110_).m_110675_(RenderStateShard.f_110123_).m_110687_(RenderStateShard.f_110115_).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110691_(false));
    }

    static ParticleRenderType translucentSheet(final Supplier<ShaderInstance> shader) {
        return new ParticleRenderType(){

            public void m_6505_(BufferBuilder builder, TextureManager manager) {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader((Supplier)shader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator tess) {
                tess.m_85914_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
            }
        };
    }
}

